//=============================================================================
// Button1.
//=============================================================================
class CaptureSoundButton extends MSCCraftingDeco;

#exec TEXTURE IMPORT NAME="CaptureSoundButton" FILE="Textures\SoundCaptureButton.pcx" GROUP=Skins

#exec TEXTURE IMPORT NAME="FSoundSign" FILE="Textures\FSoundSign.pcx" GROUP=Paper
#exec TEXTURE IMPORT NAME="RSoundSign" FILE="Textures\RSoundSign.pcx" GROUP=Paper
#exec TEXTURE IMPORT NAME="FRSoundSign" FILE="Textures\FRSoundSign.pcx" GROUP=Paper
#exec TEXTURE IMPORT NAME="SSoundSign" FILE="Textures\SSoundSign.pcx" GROUP=Paper

enum ESoundType
{
        FireSound,
        ReloadSound,
        FinishReloadSound,
        SelectSound
};

var() ESoundType ValidTypes; //used to assist mappers.

var() sound CaptureSound;
var() String CaptureType;

var Vector	lastLoc, rpcLocation;
var bool		bIsMoving;
var rotator rpcRotation;

replication 
{
	reliable if ( Role == ROLE_Authority )
		rpcLocation, rpcRotation;
}

function Frob(Actor F, Inventory FW)
{
 if ( WeaponCraftBox(DeusExPlayer(F).inHand) == None)
 {
  Pawn(F).ClientMessage("|p4Please equip your weapon parts box first.");
  return;
 }

 if (DeusExPlayer(F) != None && WeaponCraftBox(DeusExPlayer(F).inHand) != None)
 {
  PlaySound(sound'Beep1', SLOT_Misc, 255, False, 128);
  WeaponCraftBox(DeusExPlayer(F).inHand).SetPropertyText(CaptureType, String(CaptureSound));
  Pawn(F).ClientMessage("|p4"$CaptureType$" is now "$CaptureSound$"!");
 }
}

singular function SupportActor(Actor standingActor)
{
	// do nothing
}

function Bump(actor Other)
{
	// do nothing
}

simulated function Tick( float deltaTime )
{						  	
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Role == ROLE_Authority )
		{
			// Was moving, now at rest
			if ( bIsMoving && ( Location == lastLoc ))
			{
				rpcLocation = Location;
                                rpcRotation = Rotation;
			}
			bIsMoving = ( Location != lastLoc );
			lastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest
			if ( lastLoc != rpcLocation )
			{
				SetLocation( rpcLocation );
				SetRotation( rpcRotation );
				lastLoc = rpcLocation;
			}
		}
	}
	Super.Tick( deltaTime );
}
defaultproperties
{
     bBlockActors=True
     bBlockPlayers=True
     bInvincible=True
     ItemName="Sound Capture Button"
     bPushable=False
     Physics=PHYS_None
     Skin=Texture'CaptureSoundButton'
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'DeusExDeco.Button1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bCollideWorld=False
     Mass=5.000000
     Buoyancy=2.000000
}

